#!/bin/bash

typeset jsonFile=$1
typeset jsonFileBasename=`basename $jsonFile`

typeset base=mongoImport
typeset baseShellScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments
typeset deployScript=${deploymentsDir}/${baseShellScript}

typeset envScript='../set.env.sh'

rm -f $errorLog
mkdir -p $deploymentsDir

if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > ${deployScript}
#!/bin/bash

mongoimport --ssl --sslAllowInvalidCertificates --db var-utility --collection clinical-services --drop \
	--file "/vagrant/deployments/$1" --jsonArray -u var-utility -p var-utility
EOF

chmod +x $deployScript
cp $jsonFile $deploymentsDir

cd $VAGRANT_DIR
if [[ -f $envScript ]]; then
	. $envScript
fi

vagrant ssh vamf_mongo3 --command "/vagrant/deployments/$baseShellScript $jsonFileBasename > $deployLog 2>&1"
